<?php
/**
 * Plugin Name: SIMNSA Brokers Login
 * Description: Login personalizado para brokers vía API JWT.
 * Version: 1.0
 * Author: Mario Dominguez
 */
add_action('init', function () {
    if (!session_id()) {
        if (!headers_sent()) {
            session_start();
            error_log('73 Sesin iniciada correctamente.');
        } else {
            error_log('74 No se pudo iniciar sesin: headers ya enviados.');
        }
    } else {
        error_log('6715 Sesin ya estaba iniciada.');
    }
});

if (!defined('ABSPATH')) exit; // Seguridad

// Cargar archivos
define('SIMNSA_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('SIMNSA_PLUGIN_URL', plugin_dir_url(__FILE__));

// Incluir funciones necesarias
include_once SIMNSA_PLUGIN_PATH . 'includes/functions.php';

// Crear shortcode para el login
add_shortcode('simnsa_login_form', 'simnsa_render_login_form');

// Redirección si no hay sesión iniciada
add_action('template_redirect', 'simnsa_force_login');
