<?php
if (!defined('ABSPATH')) exit; // Seguridad

// Ruta de la plantilla
function simnsa_render_login_form() {
    // Si ya está logueado, redirigir al home
    if (isset($_SESSION['simnsa_token'])) {
        wp_redirect(home_url());
        exit;
    }

    ob_start();
    include SIMNSA_PLUGIN_PATH . 'templates/login-form.php';
    return ob_get_clean();
}

// Forzar login en todas las páginas excepto /login
function simnsa_force_login() {
    if (is_user_logged_in() && current_user_can('administrator')) {
        return; // Permitir acceso completo a admins logueados en WP
    }

    if (is_page('login')) return;
        //si no hay token redirigir
    if (!isset($_SESSION['simnsa_token'])) {
        wp_redirect(home_url('/login'));
        exit;
    }
}


// Función para procesar el login
function simnsa_process_login() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['simnsa_login_nonce']) && wp_verify_nonce($_POST['simnsa_login_nonce'], 'simnsa_login')) {
        $username = sanitize_text_field($_POST['username']);
        $password = sanitize_text_field($_POST['password']);

        $response = wp_remote_post('https://data-dev-brokers.simnsa.com/api/v1/Auth/Login', array(
            'headers' => array('Content-Type' => 'application/json'),
            'body' => json_encode(array(
                'username' => $username,
                'password' => $password,
            )),
            'timeout' => 15,
        ));
        

        if (is_wp_error($response)) {
    echo '<pre>' . print_r($response, true) . '</pre>';
    $_SESSION['simnsa_error'] = 'Error de conexión con el servidor.';
    return;
}


        $code = wp_remote_retrieve_response_code($response);
        $body = json_decode(wp_remote_retrieve_body($response), true);

        if ($code === 200 && isset($body['token'])) {
            $_SESSION['simnsa_token'] = $body['token'];
            $_SESSION['simnsa_refresh'] = $body['refreshToken'];
            $_SESSION['simnsa_broker'] = $body['broker'];
            wp_redirect(home_url());
            exit;
        } else {
            $_SESSION['simnsa_error'] = 'Credenciales inválidas.';
        }
    }
}
add_action('init', 'simnsa_process_login');

// Iniciar sesión PHP si no está activa
add_action('init', function () {
    if (!session_id()) {
        session_start();
    }
});
